#include <avr32/io.h>


#include "compiler.h"
#include "preprocessor.h"
#include "board.h"
#if ((defined (__GNUC__) && (defined (__AVR32_UC3L016__) || defined (__AVR32_UC3L032__) || defined (__AVR32_UC3L064__))) \
    ||(defined (__ICCAVR32__) && (defined (__AT32UC3L016__) || defined (__AT32UC3L032__) || defined (__AT32UC3L064__)  )))
// Note: for UC3L devices, the clock configurations are handled by the SCIF module
// and the synchronous clocks used to clock the main digital logic are handled
// by the PM module.
#include "power_clocks_lib.h"
#elif ( defined (__GNUC__) && ( defined (__AVR32_UC3C064C__) || defined (__AVR32_UC3C0128C__) || defined (__AVR32_UC3C0256C__) || defined (__AVR32_UC3C0512CREVC__) || defined (__AVR32_UC3C164C__) || defined (__AVR32_UC3C1128C__) || defined (__AVR32_UC3C1256C__) || defined (__AVR32_UC3C1512CREVC__) || defined (__AVR32_UC3C264C__) || defined (__AVR32_UC3C2128C__) || defined (__AVR32_UC3C2256C__) || defined (__AVR32_UC3C2512CREVC__))) \
    ||( defined (__ICCAVR32__) && ( defined (__AT32UC3C064C__) || defined (__AT32UC3C0128C__) || defined (__AT32UC3C0256C__) || defined (__AT32UC3C0512C__) || defined (__AT32UC3C164C__) || defined (__AT32UC3C1128C__) || defined (__AT32UC3C1256C__) || defined (__AT32UC3C1512C__) || defined (__AT32UC3C264C__) || defined (__AT32UC3C2128C__) || defined (__AT32UC3C2256C__) || defined (__AT32UC3C2512C__)))
#include "scif_uc3c.h"
#include "pm_uc3c.h"
#else
#include "pm.h"
#endif
#include "gpio.h"



#include "gpio_local_bus_example.h"






int main(void) {

	// Initialize domain clocks (CPU, HSB, PBA and PBB) to the max frequency available
	// without flash wait states.
	// Some of the registers in the GPIO module are mapped onto the CPU local bus.
	// To ensure maximum transfer speed and cycle determinism, any slaves being
	// addressed by the CPU on the local bus must be able to receive and transmit
	// data on the bus at CPU clock speeds. The consequences of this is that the
	// GPIO module has to run at the CPU clock frequency when local bus transfers
	// are being performed => we want fPBA = fCPU.
	fcpu_fpba_configure();

	// Enable the local bus interface for GPIO.
	gpio_local_init();

	// Enable the output driver of the example pin.
	// Note that the GPIO mode of pins is enabled by default after reset.

	gpio_local_enable_pin_output_driver(AVR32_PIN_PA03);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA04);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA05);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA06);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA07);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA08);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA09);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA10);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA11);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA12);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA13);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA14);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA15);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA16);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA17);
	//
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA20);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA21);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA22);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA23);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA24);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA25);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA26);
	gpio_local_enable_pin_output_driver(AVR32_PIN_PA27);


	while (1) {

		gpio_local_tgl_gpio_pin(AVR32_PIN_PA03);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA04);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA05);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA06);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA07);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA08);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA09);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA10);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA11);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA12);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA13);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA14);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA15);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA16);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA17);
		//
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA20);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA21);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA22);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA23);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA24);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA25);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA26);
		gpio_local_tgl_gpio_pin(AVR32_PIN_PA27);
	}

	return 0;
}
