`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    19:24:49 08/30/2009 
// Design Name: 
// Module Name:    ColouringTheWorld 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module VGA_STATE(
    input CLK,
	 input  [1:0] MASTER_STATE,
    output [7:0] COLOUR_OUT,
    output HS,
    output HV
);
// Time in Vertical Lines
parameter VertTimeToPulseWidthEnd  = 10'd2;
parameter VertTimeToBackPorchEnd   = 10'd31;
parameter VertTimeToDisplayTimeEnd = 10'd511;
parameter VertTimeToFrontPorchEnd  = 10'd521;

// Time in Horizontal Lines
parameter HorzTimeToPulseWidthEnd  = 10'd96;
parameter HorzTimeToBackPorchEnd   = 10'd144;
parameter HorzTimeToDisplayTimeEnd = 10'd784;
parameter HorzTimeToFrontPorchEnd  = 10'd800;

wire TrigHOut, TrigVOut, TrigDiv;
wire [9:0] HorzCount;
wire [9:0] VertCount;
reg [7:0] Colour;
wire [7:0] FrameCount;

always@(posedge CLK)  begin

	if(MASTER_STATE == 2'b10) begin
		if(VertCount[9:0] > 280) begin
			if(HorzCount[9:0] > 450)
				Colour <= FrameCount[7:0] + VertCount[7:0] + HorzCount[7:0] - 280 - 450;
			else
				Colour <= FrameCount[7:0] + VertCount[7:0] - HorzCount[7:0] - 280 + 450;
		end
		else begin
			if(HorzCount[9:0] > 450)
				Colour <= FrameCount[7:0] - VertCount[7:0] + HorzCount[7:0] + 280 - 450;
			else
				Colour <= FrameCount[7:0] - VertCount[7:0] - HorzCount[7:0] + 280+ 450;	
		end

	end else
		Colour <= 8'b00000000;
	
end



GenericCounter  #(.COUNTER_WIDTH(1), .COUNTER_MAX(1))
FreqDivider
(
	.CLK(CLK),
	.RESET(1'b0),
	.ENABLE_IN(1'b1),
	.TRIG_OUT(TrigDiv)
);


GenericCounter  #(.COUNTER_WIDTH(10), .COUNTER_MAX(HorzTimeToFrontPorchEnd))
HorzAddrCounter
(
	.CLK(CLK),
	.RESET(1'b0),
	.ENABLE_IN(TrigDiv),
	.TRIG_OUT(TrigHOut),
	.COUNT(HorzCount)
);

GenericCounter  #(.COUNTER_WIDTH(10), .COUNTER_MAX(513))
VertAddrCounter
(
	.CLK(CLK),
	.RESET(1'b0),
	.ENABLE_IN(TrigHOut),
	.TRIG_OUT(TrigVOut),
	.COUNT(VertCount)
);

GenericCounter  #(.COUNTER_WIDTH(8), .COUNTER_MAX(127))
FrameCounter
(
	.CLK(CLK),
	.RESET(1'b0),
	.ENABLE_IN(TrigVOut),
	.COUNT(FrameCount)
);
 

VGA_Interface VGAInst(
    .CLK(CLK),
    .COLOUR_IN(Colour),
    .COLOUR_OUT(COLOUR_OUT),
    .ADDRH(HorzCount),
    .ADDRV(VertCount),
    .HS(HS),
    .HV(HV)
);


endmodule
