`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    12:59:26 09/01/2009 
// Design Name: 
// Module Name:    LED_StrobeSM 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module LED_StrobeSM(
    input CLK,
    input RESET,
    input [1:0] MASTER_STATE,
    output [7:0] LED_DISPLAY,
    output [3:0] LED_STROBE_SM_OUT
);


reg [3:0] Current_State;
reg [3:0] Next_State;
reg [7:0] LED_Current;
reg [7:0] LED_Next;
wire Trig;

GenericCounter #(.COUNTER_WIDTH(26), .COUNTER_MAX(49000000))
CounterSec
(
	.CLK(CLK),
	.RESET(RESET),
 	.ENABLE_IN(1'b1),
	.TRIG_OUT(Trig)
);


always@(posedge CLK) begin
	if(RESET) begin
		Current_State <= 4'b0000;
		LED_Current <= 8'b00000000;
	end else begin
		Current_State <= Next_State;
		LED_Current <= LED_Next;
	end
end

always@(Current_State or MASTER_STATE or Trig or LED_Current) begin

		case (Current_State)

			4'b0000 : begin
				if(MASTER_STATE == 2'b11) begin
					Next_State <= 4'b0001;
					LED_Next <= 8'b00000001;
				end else begin
					Next_State <= Current_State;
					LED_Next <= 8'b00000000;
					end
				end

			4'b0001: begin
				if(Trig) begin
					Next_State <= 4'b0010;
					LED_Next <= 8'b00000010;
				end  else begin
					Next_State <= Current_State;
					LED_Next <= 8'b00000001;
				end
				end

			4'b0010 : begin
				if(Trig) begin
					Next_State <= 4'b0011;
					LED_Next <= 8'b00000100;
				end  else begin
					Next_State <= Current_State;
					LED_Next <= 8'b00000010;					
				end
					
				end			
			4'b0011: begin
				if(Trig) begin
					Next_State <= 4'b0100;
					LED_Next <= 8'b00001000;
				end   else begin
					Next_State <= Current_State;
					LED_Next <= 8'b00000100;
				end
				
				end	

			4'b0100 : begin
				if(Trig) begin
					Next_State <= 4'b0101;
					LED_Next <= 8'b00010000;
				end   else begin
					Next_State <= Current_State;
					LED_Next <= 8'b00001000;
				end
				end	
			
			4'b0101: begin
				if(Trig) begin
					Next_State <= 4'b0110;
					LED_Next <= 8'b00100000;
				end   else begin
					Next_State <= Current_State;
					LED_Next <= 8'b00010000;
				end
				end	

			4'b0110 : begin
				if(Trig) begin
					Next_State <= 4'b0111;
					LED_Next <= 8'b01000000;
				end   else  begin
					Next_State <= Current_State;
					LED_Next <= 8'b00100000;
				end
				end	
			
			4'b0111: begin
				if(Trig) begin
					Next_State <= 4'b1000;
					LED_Next <= 8'b10000000;
				end   else begin
					Next_State <= Current_State;
					LED_Next <= 8'b01000000;
				end
				end	

			4'b1000: begin
				if(Trig) begin
					Next_State <= 4'b1001;
					LED_Next <= 8'b00000000;
				end   else  begin
					Next_State <= Current_State;
					LED_Next <= 8'b10000000;
				end
				end	

//			4'b1001: begin
//				if(Trig) begin
//					Next_State <= 4'b0000;
//					LED_Next <= 8'b00000000;
//				end   else  begin
//					Next_State <= Current_State;
//					LED_Next <= 8'b00000000;
//				end
//				end	
				
			default: begin
				LED_Next <= LED_Current;
				Next_State <= Current_State;
			end
			
		endcase

		

end


assign LED_DISPLAY = LED_Current;
assign LED_STROBE_SM_OUT = Current_State;

endmodule
