`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    19:24:49 08/30/2009 
// Design Name: 
// Module Name:    VGA_Interface
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module VGA_Interface(
    input CLK,
    input [7:0] COLOUR_IN,
    output reg [7:0] COLOUR_OUT,
    input [9:0] ADDRH,
    input [8:0] ADDRV,
    output reg HS,
    output reg HV
    );


// Time in Vertical Lines
parameter VertTimeToPulseWidthEnd  = 10'd2;
parameter VertTimeToBackPorchEnd   = 10'd31;
parameter VertTimeToDisplayTimeEnd = 10'd511;
parameter VertTimeToFrontPorchEnd  = 10'd521;

// Time in Horizontal Lines
parameter HorzTimeToPulseWidthEnd  = 10'd96;
parameter HorzTimeToBackPorchEnd   = 10'd144;
parameter HorzTimeToDisplayTimeEnd = 10'd784;
parameter HorzTimeToFrontPorchEnd  = 10'd800;


always@(posedge CLK) begin
	if(ADDRH<HorzTimeToPulseWidthEnd)
			HS <= 1'b0;
	else
			HS <= 1'b1;

	if(ADDRV<VertTimeToPulseWidthEnd)
			HV <= 1'b0;
	else
			HV <= 1'b1;
end


always@(posedge CLK) begin
	if ( ( (ADDRH >= HorzTimeToBackPorchEnd ) && (ADDRH <= HorzTimeToDisplayTimeEnd) ) &&
		  ( (ADDRV >= VertTimeToBackPorchEnd ) && (ADDRV <= VertTimeToDisplayTimeEnd) ) ) 
		COLOUR_OUT <= COLOUR_IN;
	else
		COLOUR_OUT <= 8'b00000000;
end



endmodule
