`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    19:24:49 08/30/2009 
// Design Name: 
// Module Name:    ColouringTheWorld 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module VGAControl(
    input CLK,
    input [7:0] COLOUR_IN,
    output reg [7:0] COLOUR_OUT,
    output reg [9:0] ADDRH,
    output reg [8:0] ADDRV,
    output reg HS,
    output reg HV
    );

wire [9:0] HorzPixCount;
wire [8:0] VertPixCount;

// Time in Vertical Lines
parameter VertTimeToPulseWidthEnd  = 10'd2;
parameter VertTimeToBackPorchEnd   = 10'd31;
parameter VertTimeToDisplayTimeEnd = 10'd511;
parameter VertTimeToFrontPorchEnd  = 10'd521;

// Time in Horizontal Lines
parameter HorzTimeToPulseWidthEnd  = 10'd96;
parameter HorzTimeToBackPorchEnd   = 10'd144;
parameter HorzTimeToDisplayTimeEnd = 10'd784;
parameter HorzTimeToFrontPorchEnd  = 10'd800;

GenericCounter  #(.COUNTER_WIDTH(10), .COUNTER_MAX(HorzTimeToFrontPorchEnd))
HorzAddrCounter
(
	.CLK(CLK),
	.RESET(1'b0),
	.ENABLE_IN(1'b1),
	.COUNT(HorzPixCount)
);

GenericCounter  #(.COUNTER_WIDTH(9), .COUNTER_MAX(VertTimeToFrontPorchEnd))
VertAddrCounter
(
	.CLK(CLK),
	.RESET(1'b0),
	.ENABLE_IN(1'b1),
	.COUNT(VertPixCount)
);

always@(posedge CLK) begin
	if(HorzPixCount<HorzTimeToPulseWidthEnd)
			HS <= 1'b0;
	else
			HS <= 1'b1;

	if(VertPixCount<VertTimeToPulseWidthEnd)
			HV <= 1'b0;
	else
			HV <= 1'b1;
end


always@(posedge CLK) begin
	if ( (HorzTimeToBackPorchEnd < HorzPixCount < HorzTimeToDisplayTimeEnd) &&
		  (VertTimeToBackPorchEnd < VertPixCount < VertTimeToDisplayTimeEnd) ) 
		begin
			COLOUR_OUT <= COLOUR_IN;
			ADDRH <= HorzPixCount;
			ADDRV <= VertPixCount;
		end
	else
		COLOUR_OUT <= 8'b00000000;
end



endmodule
