`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    22:58:17 08/31/2009 
// Design Name: 
// Module Name:    StateMachineWorld 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module StateMaze(
    input BTN1,
    input BTN2,
    input BTN3,
    input CLK,
    input RESET,
    input [1:0] MASTER_STATE,
    output [3:0] STATE_OUT
    );

reg [3:0] Current_State;
reg [3:0] Next_State;

assign STATE_OUT = Current_State;

always@(posedge CLK) begin
		if(RESET) 
			Current_State <= 4'b1111;
		else
			Current_State <= Next_State;
end

always@(Current_State or BTN1 or BTN2 or BTN3 or RESET or MASTER_STATE)

	case (Current_State)
	
		4'b1111 : begin
			if(MASTER_STATE == 2'b01) 
				Next_State <= 4'b0000;
			else
				Next_State <= Current_State;
		end

		4'b0000 : begin
			if(BTN2)
				Next_State <= 4'b0110;
			else
				Next_State <= Current_State;
		end
	
		4'b0001 : begin
			if(BTN2)
				Next_State <= 4'b0010;
			else if(BTN1)
				Next_State <= 4'b0101;
				else
				Next_State <= Current_State;
		end
	
		4'b0010 : begin
			if(BTN2)
				Next_State <= 4'b0001;
			else if(BTN1)
				Next_State <= 4'b0000;
				else
				Next_State <= Current_State;
		end

		4'b0011 : begin
			if(BTN1)
				Next_State <= 4'b0100;
			else if(BTN3)
				Next_State <= 4'b0010;
				else
				Next_State <= Current_State;
		end

		4'b0100 : begin
			if(BTN2)
				Next_State <= 4'b0110;
			else if(BTN3)
				Next_State <= 4'b0111;
				else
				Next_State <= Current_State;
		end

		4'b0101 : begin
			if(BTN2)
				Next_State <= 4'b0011;
			else if(BTN3)
				Next_State <= 4'b0000;
				else
				Next_State <= Current_State;
		end

		4'b0110 : begin
			if(BTN2)
				Next_State <= 4'b0001;
			else if(BTN3)
				Next_State <= 4'b0010;
				else
				Next_State <= Current_State;
		end

		4'b0111 : 
			if(BTN1)
				Next_State <= 4'b1000;
			else 
				Next_State <= Current_State;

		4'b1000 : 
			if(RESET)
				Next_State <= 4'b1111;
			else 
				Next_State <= Current_State;

		
		default : Next_State <= 4'b1111;

	
	endcase



endmodule
