`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    22:58:17 08/31/2009 
// Design Name: 
// Module Name:    StateMachineWorld 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module MasterSM(
    input BTN1,
    input BTN2,
    input BTN3,
    input CLK,
    input RESET,
    input LED_Finished,
    input Maze_Finished,
    output [1:0] MASTER_STATE
   );

reg [1:0] Current_State;
reg [1:0] Next_State;

assign MASTER_STATE = Current_State;

always@(posedge CLK) begin
		if(RESET) 
			Current_State <= 2'b00;
		else
			Current_State <= Next_State;
end

always@(Current_State or BTN1 or BTN2 or BTN3 or RESET or LED_Finished or Maze_Finished)

	case (Current_State)
	
		2'b00 : begin
			if(BTN1) 
				Next_State <= 2'b01;
			else begin if(BTN2)
					Next_State <= 2'b10;
				else begin if(BTN3)
					Next_State <= 2'b11;
				else
					Next_State <= Current_State;
					end
				end
			end

		2'b01 : begin
			if(Maze_Finished)
				Next_State <= 2'b10;
			else
				Next_State <= Current_State;
		end

		2'b10 : Next_State <= Current_State;
		
		2'b11 : begin
			if(LED_Finished)
				Next_State <= 2'b10;
			else
				Next_State <= Current_State;
		end
	
//		default : Next_State <= 2'b00;

	
	endcase



endmodule
