`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    12:47:59 09/01/2009 
// Design Name: 
// Module Name:    LinkedStateMachine 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module LinkedStateMachine(
    input BTN1,
	 input BTN2,
	 input BTN3,
    input Maze_BTN1,
	 input Maze_BTN2,
	 input Maze_BTN3,
	 input CLK,
    input RESET,
    output [7:0] LED_DISPLAY,
	 output [7:0] COLOUR_OUT,
	 output [7:0] HEX_OUT,
    output [3:0] SEG_SELECT,
    output HS,
    output HV
);

wire [1:0] MASTER_STATE;
wire [3:0] LED_STATE;
wire [3:0] MAZE_STATE;
reg Maze_Finished;
reg LED_Finished;

always@(posedge CLK) begin

	
	if(LED_STATE == 4'b1001)
		LED_Finished <= 1'b1;		
	else
		LED_Finished <= 1'b0;

	if(MAZE_STATE == 4'b1000)
		Maze_Finished <= 1'b1;		
	else
		Maze_Finished <= 1'b0;


end

MasterSM  MSM(
    .BTN1(BTN1),
    .BTN2(BTN2),
    .BTN3(BTN3),
    .CLK(CLK),
    .RESET(RESET),
    .LED_Finished(LED_Finished),
    .Maze_Finished(Maze_Finished),
    .MASTER_STATE(MASTER_STATE)
);


VGA_STATE  VGA(
    .CLK(CLK),
	 .MASTER_STATE(MASTER_STATE),
    .COLOUR_OUT(COLOUR_OUT),
    .HS(HS),
    .HV(HV)
);

LED_StrobeSM  LED(
    .CLK(CLK),
    .RESET(RESET),
    .MASTER_STATE(MASTER_STATE),
    .LED_DISPLAY(LED_DISPLAY),
	 .LED_STROBE_SM_OUT(LED_STATE)
);

StateMaze_TOP  MAZE(
    .BTN1(Maze_BTN1),
    .BTN2(Maze_BTN2),
    .BTN3(Maze_BTN3),
    .CLK(CLK),
    .RESET(RESET),
    .MASTER_STATE(MASTER_STATE),
    .STATE_OUT(MAZE_STATE),
	 .HEX_OUT(HEX_OUT),
    .SEG_SELECT(SEG_SELECT)
);


endmodule
